import{ObjectWrapper as e,Revealer as t,Settings as s,UIString as o}from"../common/common.js";import{SDKModel as i,CPUProfilerModel as n,CSSModel as r,DebuggerModel as a,ResourceTreeModel as c}from"../sdk/sdk.js";import{Text as l,TextRange as h}from"../text_utils/text_utils.js";import{DataGrid as d,SortableDataGrid as u}from"../data_grid/data_grid.js";import{sourceFormatter as g}from"../formatter/formatter.js";import{ls as _,NumberUtilities as p,DateUtilities as v}from"../platform/platform.js";import{Widget as f,UIUtils as m,Toolbar as S,ActionRegistry as C,ViewManager as y}from"../ui/ui.js";import{Workspace as b,UISourceCode as B}from"../workspace/workspace.js";import{DebuggerWorkspaceBinding as w,CSSWorkspaceBinding as T,FileUtils as x}from"../bindings/bindings.js";import{userMetrics as R,UserMetrics as P}from"../host/host.js";import{SourcesTextEditor as I}from"../source_frame/source_frame.js";const L={CSS:1,JavaScript:2,JavaScriptPerFunction:4},k={Active:Symbol("Active"),Suspending:Symbol("Suspending"),Suspended:Symbol("Suspended")},M={CoverageUpdated:Symbol("CoverageUpdated"),CoverageReset:Symbol("CoverageReset")};class E extends i.SDKModel{constructor(e){super(e),this._cpuProfilerModel=e.model(n.CPUProfilerModel),this._cssModel=e.model(r.CSSModel),this._debuggerModel=e.model(a.DebuggerModel),this._coverageByURL=new Map,this._coverageByContentProvider=new Map,this._coverageUpdateTimes=new Set,this._suspensionState=k.Active,this._pollTimer=null,this._currentPollPromise=null,this._shouldResumePollingOnResume=!1,this._jsBacklog=[],this._cssBacklog=[],this._performanceTraceRecording=!1}async start(e){if(this._suspensionState!==k.Active)throw Error("Cannot start CoverageModel while it is not active.");const t=[];return this._cssModel&&(this._clearCSS(),this._cssModel.addEventListener(r.Events.StyleSheetAdded,this._handleStyleSheetAdded,this),t.push(this._cssModel.startCoverage())),this._cpuProfilerModel&&t.push(this._cpuProfilerModel.startPreciseCoverage(e,this.preciseCoverageDeltaUpdate.bind(this))),await Promise.all(t),!(!this._cssModel&&!this._cpuProfilerModel)}preciseCoverageDeltaUpdate(e,t,s){this._coverageUpdateTimes.add(e),this._backlogOrProcessJSCoverage(s,e)}async stop(){await this.stopPolling();const e=[];this._cpuProfilerModel&&e.push(this._cpuProfilerModel.stopPreciseCoverage()),this._cssModel&&(e.push(this._cssModel.stopCoverage()),this._cssModel.removeEventListener(r.Events.StyleSheetAdded,this._handleStyleSheetAdded,this)),await Promise.all(e)}reset(){this._coverageByURL=new Map,this._coverageByContentProvider=new Map,this._coverageUpdateTimes=new Set,this.dispatchEventToListeners(M.CoverageReset)}async startPolling(){this._currentPollPromise||this._suspensionState!==k.Active||await this._pollLoop()}async _pollLoop(){this._clearTimer(),this._currentPollPromise=this._pollAndCallback(),await this._currentPollPromise,(this._suspensionState===k.Active||this._performanceTraceRecording)&&(this._pollTimer=window.setTimeout(()=>this._pollLoop(),200))}async stopPolling(){this._clearTimer(),await this._currentPollPromise,this._currentPollPromise=null,await this._pollAndCallback()}async _pollAndCallback(){if(this._suspensionState===k.Suspended&&!this._performanceTraceRecording)return;const e=await this._takeAllCoverage();console.assert(this._suspensionState!==k.Suspended||!!this._performanceTraceRecording,"CoverageModel was suspended while polling."),e.length&&this.dispatchEventToListeners(M.CoverageUpdated,e)}_clearTimer(){this._pollTimer&&(clearTimeout(this._pollTimer),this._pollTimer=null)}async preSuspendModel(e){this._suspensionState===k.Active&&(this._suspensionState=k.Suspending,"performance-timeline"!==e?this._currentPollPromise&&(await this.stopPolling(),this._shouldResumePollingOnResume=!0):this._performanceTraceRecording=!0)}async suspendModel(e){this._suspensionState=k.Suspended}async resumeModel(){}async postResumeModel(){this._suspensionState=k.Active,this._performanceTraceRecording=!1,this._shouldResumePollingOnResume&&(this._shouldResumePollingOnResume=!1,await this.startPolling())}entries(){return Array.from(this._coverageByURL.values())}getCoverageForUrl(e){return this._coverageByURL.get(e)||null}usageForRange(e,t,s){const o=this._coverageByContentProvider.get(e);return o&&o.usageForRange(t,s)}_clearCSS(){for(const e of this._coverageByContentProvider.values()){if(e.type()!==L.CSS)continue;const t=e.contentProvider();this._coverageByContentProvider.delete(t);const s=`${t.startLine}:${t.startColumn}`,o=this._coverageByURL.get(e.url());o&&o._coverageInfoByLocation.delete(s)&&(o._addToSizes(-e._usedSize,-e._size),o._coverageInfoByLocation.size||this._coverageByURL.delete(e.url()))}if(this._cssModel)for(const e of this._cssModel.getAllStyleSheetHeaders())this._addStyleSheetToCSSCoverage(e)}async _takeAllCoverage(){const[e,t]=await Promise.all([this._takeCSSCoverage(),this._takeJSCoverage()]);return[...e,...t]}async _takeJSCoverage(){if(!this._cpuProfilerModel)return[];const{coverage:e,timestamp:t}=await this._cpuProfilerModel.takePreciseCoverage();return this._coverageUpdateTimes.add(t),this._backlogOrProcessJSCoverage(e,t)}coverageUpdateTimes(){return this._coverageUpdateTimes}async _backlogOrProcessJSCoverage(e,t){if(e.length>0&&this._jsBacklog.push({rawCoverageData:e,stamp:t}),this._suspensionState!==k.Active)return[];const s=(e,t)=>e.stamp-t.stamp,o=[];for(const{rawCoverageData:e,stamp:t}of this._jsBacklog.sort(s))o.push(this._processJSCoverage(e,t));return this._jsBacklog=[],o.flat()}async processJSBacklog(){this._backlogOrProcessJSCoverage([],0)}_processJSCoverage(e,t){if(!this._debuggerModel)return[];const s=[];for(const o of e){const e=this._debuggerModel.scriptForId(o.scriptId);if(!e)continue;const i=[];let n=L.JavaScript;for(const e of o.functions){!1!==e.isBlockCoverage||1===e.ranges.length&&!e.ranges[0].count||(n|=L.JavaScriptPerFunction);for(const t of e.ranges)i.push(t)}const r=this._addCoverage(e,e.contentLength,e.lineOffset,e.columnOffset,i,n,t);r&&s.push(r)}return s}_handleStyleSheetAdded(e){const t=e.data;this._addStyleSheetToCSSCoverage(t)}async _takeCSSCoverage(){if(!this._cssModel||this._suspensionState!==k.Active)return[];const{coverage:e,timestamp:t}=await this._cssModel.takeCoverageDelta();return this._coverageUpdateTimes.add(t),this._backlogOrProcessCSSCoverage(e,t)}async _backlogOrProcessCSSCoverage(e,t){if(e.length>0&&this._cssBacklog.push({rawCoverageData:e,stamp:t}),this._suspensionState!==k.Active)return[];const s=(e,t)=>e.stamp-t.stamp,o=[];for(const{rawCoverageData:e,stamp:t}of this._cssBacklog.sort(s))o.push(this._processCSSCoverage(e,t));return this._cssBacklog=[],o.flat()}_processCSSCoverage(e,t){if(!this._cssModel)return[];const s=[],o=new Map;for(const t of e){const e=this._cssModel.styleSheetHeaderForId(t.styleSheetId);if(!e)continue;let s=o.get(e);s||(s=[],o.set(e,s)),s.push({startOffset:t.startOffset,endOffset:t.endOffset,count:Number(t.used)})}for(const e of o){const o=e[0],i=e[1],n=this._addCoverage(o,o.contentLength,o.startLine,o.startColumn,i,L.CSS,t);n&&s.push(n)}return s}static _convertToDisjointSegments(e,t){e.sort((e,t)=>e.startOffset-t.startOffset);const s=[],o=[];for(const t of e){let e=o.peekLast();for(;e&&e.endOffset<=t.startOffset;)i(e.endOffset,e.count),o.pop(),e=o.peekLast();i(t.startOffset,e?e.count:0),o.push(t)}for(let e=o.pop();e;e=o.pop())i(e.endOffset,e.count);function i(e,o){const i=s.peekLast();if(i){if(i.end===e)return;if(i.count===o)return void(i.end=e)}s.push({end:e,count:o,stamp:t})}return s}_addStyleSheetToCSSCoverage(e){this._addCoverage(e,e.contentLength,e.startLine,e.startColumn,[],L.CSS,Date.now())}_addCoverage(e,t,s,o,i,n,r){const a=e.contentURL();if(!a)return null;let c=this._coverageByURL.get(a),l=!1;c||(l=!0,c=new z(a),this._coverageByURL.set(a,c));const h=c._ensureEntry(e,t,s,o,n);this._coverageByContentProvider.set(e,h);const d=E._convertToDisjointSegments(i,r),u=d.peekLast();u&&u.end<t&&d.push({end:t,stamp:r,count:0});const g=h._usedSize;return h.mergeCoverage(d),l||h._usedSize!==g?(c._addToSizes(h._usedSize-g,0),h):null}async exportReport(e){const t=[];function s(e,t){const[s,o]=e.split(":"),[i,n]=t.split(":");return Number.parseInt(s,10)-Number.parseInt(i,10)||Number.parseInt(o,10)-Number.parseInt(n,10)}const o=Array.from(this._coverageByURL.keys()).sort();for(const e of o){const o=this._coverageByURL.get(e);if(!o)continue;const i=o.url();if(i.startsWith("extensions::")||i.startsWith("chrome-extension://"))continue;let n=!1;for(const e of o._coverageInfoByLocation.values())if(e._lineOffset||e._columnOffset){n=!!i;break}let r=null;if(n){const e=c.ResourceTreeModel.resourceForURL(i);if(e){const t=(await e.requestContent()).content;r=new l.Text(t||"")}}const a=Array.from(o._coverageInfoByLocation.keys()).sort(s);if(r){const e={url:i,ranges:[],text:r.value()};for(const t of a){const s=o._coverageInfoByLocation.get(t);if(!s)continue;const i=r?r.offsetFromPosition(s._lineOffset,s._columnOffset):0;let n=0;for(const t of s._segments)t.count?e.ranges.push({start:n+i,end:t.end+i}):n=t.end}t.push(e)}else for(const e of a){const s=o._coverageInfoByLocation.get(e);if(!s)continue;const n={url:i,ranges:[],text:(await s.contentProvider().requestContent()).content};let r=0;for(const e of s._segments)e.count?n.ranges.push({start:r,end:e.end}):r=e.end;t.push(n)}}await e.write(JSON.stringify(t,void 0,2)),e.close()}}i.SDKModel.register(E,i.Capability.None,!1);class z extends e.ObjectWrapper{constructor(e){super(),this._url=e,this._coverageInfoByLocation=new Map,this._size=0,this._usedSize=0,this._type,this._isContentScript=!1}url(){return this._url}type(){return this._type}size(){return this._size}usedSize(){return this._usedSize}unusedSize(){return this._size-this._usedSize}usedPercentage(){return 0===this._size?0:this.usedSize()/this.size()*100}unusedPercentage(){return 0===this._size?100:this.unusedSize()/this.size()*100}isContentScript(){return this._isContentScript}entries(){return this._coverageInfoByLocation.values()}_addToSizes(e,t){this._usedSize+=e,this._size+=t,0===e&&0===t||this.dispatchEventToListeners(z.Events.SizesChanged)}_ensureEntry(e,t,s,o,i){const n=`${s}:${o}`;let r=this._coverageInfoByLocation.get(n);return i&L.JavaScript&&!this._coverageInfoByLocation.size&&(this._isContentScript=e.isContentScript()),this._type|=i,r?(r._coverageType|=i,r):(i&L.JavaScript&&!this._coverageInfoByLocation.size&&(this._isContentScript=e.isContentScript()),r=new A(e,t,s,o,i),this._coverageInfoByLocation.set(n,r),this._addToSizes(0,t),r)}}z.Events={SizesChanged:Symbol("SizesChanged")};const F=(e,t)=>{const s=[];let o=0,i=0;for(;o<e.length&&i<t.length;){const n=e[o],r=t[i],a=(n.count||0)+(r.count||0),c=Math.min(n.end,r.end),l=s.peekLast(),h=Math.min(n.stamp,r.stamp);l&&l.count===a&&l.stamp===h?l.end=c:s.push({end:c,count:a,stamp:h}),n.end<=r.end&&o++,n.end>=r.end&&i++}for(;o<e.length;o++)s.push(e[o]);for(;i<t.length;i++)s.push(t[i]);return s};class A{constructor(e,t,s,o,i){this._contentProvider=e,this._size=t,this._usedSize=0,this._statsByTimestamp=new Map,this._lineOffset=s,this._columnOffset=o,this._coverageType=i,this._segments=[]}contentProvider(){return this._contentProvider}url(){return this._contentProvider.contentURL()}type(){return this._coverageType}mergeCoverage(e){this._segments=F(this._segments,e),this._updateStats()}usedByTimestamp(){return this._statsByTimestamp}size(){return this._size}usageForRange(e,t){let s=this._segments.upperBound(e,(e,t)=>e-t.end);for(;s<this._segments.length&&this._segments[s].end<t;++s)if(this._segments[s].count)return!0;return s<this._segments.length&&!!this._segments[s].count}_updateStats(){this._statsByTimestamp=new Map,this._usedSize=0;let e=0;for(const t of this._segments){if(this._statsByTimestamp.has(t.stamp)||this._statsByTimestamp.set(t.stamp,0),t.count){const s=t.end-e;this._usedSize+=s,this._statsByTimestamp.set(t.stamp,this._statsByTimestamp.get(t.stamp)+s)}e=t.end}}}var U=Object.freeze({__proto__:null,CoverageType:L,SuspensionState:k,Events:M,CoverageModel:E,URLCoverageInfo:z,mergeSegments:F,CoverageInfo:A,RangeUseCount:void 0,CoverageSegment:void 0});function O(e){const t=[];return e&L.CSS&&t.push(_`CSS`),e&L.JavaScriptPerFunction?t.push(_`JS (per function)`):e&L.JavaScript&&t.push(_`JS (per block)`),t.join("+")}class V extends f.VBox{constructor(e){super(!0),this._nodeForCoverageInfo=new Map,this._isVisibleFilter=e,this._highlightRegExp=null,this.registerRequiredCSS("coverage/coverageListView.css");const t=[{id:"url",title:_`URL`,width:"250px",fixedWidth:!1,sortable:!0},{id:"type",title:_`Type`,width:"45px",fixedWidth:!0,sortable:!0},{id:"size",title:_`Total Bytes`,width:"60px",fixedWidth:!0,sortable:!0,align:d.Align.Right},{id:"unusedSize",title:_`Unused Bytes`,width:"100px",fixedWidth:!0,sortable:!0,align:d.Align.Right,sort:d.Order.Descending},{id:"bars",title:_`Usage Visualization`,width:"250px",fixedWidth:!1,sortable:!0}];this._dataGrid=new u.SortableDataGrid({displayName:_`Code Coverage`,columns:t}),this._dataGrid.setResizeMethod(d.ResizeMethod.Last),this._dataGrid.element.classList.add("flex-auto"),this._dataGrid.element.addEventListener("keydown",this._onKeyDown.bind(this),!1),this._dataGrid.addEventListener(d.Events.OpenedNode,this._onOpenedNode,this),this._dataGrid.addEventListener(d.Events.SortingChanged,this._sortingChanged,this);const s=this._dataGrid.asWidget();s.show(this.contentElement),this.setDefaultFocusedChild(s)}update(e){let t=!1;const s=e.reduce((e,t)=>Math.max(e,t.size()),0),o=this._dataGrid.rootNode();for(const i of e){let e=this._nodeForCoverageInfo.get(i);e?this._isVisibleFilter(e._coverageInfo)&&(t=e._refreshIfNeeded(s)||t):(e=new N(i,s),this._nodeForCoverageInfo.set(i,e),this._isVisibleFilter(e._coverageInfo)&&(o.appendChild(e),t=!0))}t&&this._sortingChanged()}reset(){this._nodeForCoverageInfo.clear(),this._dataGrid.rootNode().removeChildren()}updateFilterAndHighlight(e){this._highlightRegExp=e;let t=!1;for(const e of this._nodeForCoverageInfo.values()){const s=this._isVisibleFilter(e._coverageInfo),o=!!e.parent;s&&e._setHighlight(this._highlightRegExp),s!==o&&(t=!0,s?this._dataGrid.rootNode().appendChild(e):e.remove())}t&&this._sortingChanged()}selectByUrl(e){for(const[t,s]of this._nodeForCoverageInfo.entries())if(t.url()===e){s.revealAndSelect();break}}_onOpenedNode(){this._revealSourceForSelectedNode()}_onKeyDown(e){isEnterKey(e)&&(e.consume(!0),this._revealSourceForSelectedNode())}async _revealSourceForSelectedNode(){const e=this._dataGrid.selectedNode;if(!e)return;const s=e._coverageInfo;let o=b.WorkspaceImpl.instance().uiSourceCodeForURL(s.url());if(!o)return;o=(await g.format(o)).formattedSourceCode,this._dataGrid.selectedNode===e&&t.reveal(o)}_sortingChanged(){const e=this._dataGrid.sortColumnId();if(!e)return;const t=N.sortFunctionForColumn(e);t&&this._dataGrid.sortNodes(t,!this._dataGrid.isSortOrderAscending())}}class N extends u.SortableDataGridNode{constructor(e,t){super(),this._coverageInfo=e,this._lastUsedSize,this._url=e.url(),this._maxSize=t,this._highlightRegExp=null}_setHighlight(e){this._highlightRegExp!==e&&(this._highlightRegExp=e,this.refresh())}_refreshIfNeeded(e){return(this._lastUsedSize!==this._coverageInfo.usedSize()||e!==this._maxSize)&&(this._lastUsedSize=this._coverageInfo.usedSize(),this._maxSize=e,this.refresh(),!0)}createCell(e){const t=this.createTD(e);switch(e){case"url":{t.title=this._url;const s=t.createChild("div","url-outer"),o=s.createChild("div","url-prefix"),i=s.createChild("div","url-suffix"),n=/^(.*)(\/[^/]*)$/.exec(this._url);o.textContent=n?n[1]:this._url,i.textContent=n?n[2]:"",this._highlightRegExp&&this._highlight(s,this._url),this.setCellAccessibleName(this._url,t,e);break}case"type":t.textContent=O(this._coverageInfo.type()),this._coverageInfo.type()&L.JavaScriptPerFunction?t.title=_`JS coverage with per function granularity: Once a function was executed, the whole function is marked as covered.`:this._coverageInfo.type()&L.JavaScript&&(t.title=_`JS coverage with per block granularity: Once a block of JavaScript was executed, that block is marked as covered.`);break;case"size":{t.createChild("span").textContent=Number.withThousandsSeparator(this._coverageInfo.size()||0);const s=1===this._coverageInfo.size()?_`1 byte`:_`${this._coverageInfo.size()||0} bytes`;this.setCellAccessibleName(s,t,e);break}case"unusedSize":{const s=this._coverageInfo.unusedSize()||0,o=t.createChild("span"),i=t.createChild("span","percent-value");o.textContent=Number.withThousandsSeparator(s);const n=_`${this._percentageString(this._coverageInfo.unusedPercentage())} %`;i.textContent=n;const r=1===s?_`1 byte, ${n}`:_`${s} bytes, ${n}`;this.setCellAccessibleName(r,t,e);break}case"bars":{const s=t.createChild("div","bar-container"),o=this._percentageString(this._coverageInfo.unusedPercentage()),i=this._percentageString(this._coverageInfo.usedPercentage());if(this._coverageInfo.unusedSize()>0){const e=s.createChild("div","bar bar-unused-size");e.style.width=(this._coverageInfo.unusedSize()/this._maxSize*100||0)+"%",this._coverageInfo.type()&L.JavaScriptPerFunction?e.title=_`${this._coverageInfo.unusedSize()} bytes (${o} %) belong to functions that have not (yet) been executed.`:this._coverageInfo.type()&L.JavaScript&&(e.title=_`${this._coverageInfo.unusedSize()} bytes (${o} %) belong to blocks of JavaScript that have not (yet) been executed.`)}if(this._coverageInfo.usedSize()>0){const e=s.createChild("div","bar bar-used-size");e.style.width=(this._coverageInfo.usedSize()/this._maxSize*100||0)+"%",this._coverageInfo.type()&L.JavaScriptPerFunction?e.title=_`${this._coverageInfo.usedSize()} bytes (${i} %) belong to functions that have executed at least once.`:this._coverageInfo.type()&L.JavaScript&&(e.title=_`${this._coverageInfo.usedSize()} bytes (${i} %) belong to blocks of JavaScript that have executed at least once.`)}this.setCellAccessibleName(_`${o} % of file unused, ${i} % of file used`,t,e)}}return t}_percentageString(e){return e.toFixed(1)}_highlight(e,t){if(!this._highlightRegExp)return;const s=this._highlightRegExp.exec(t);if(!s||!s.length)return;const o=new h.SourceRange(s.index,s[0].length);m.highlightRangesWithStyleClass(e,[o],"filter-highlight")}static sortFunctionForColumn(e){const t=(e,t)=>e._url.localeCompare(t._url);switch(e){case"url":return t;case"type":return(e,s)=>{const o=O(e._coverageInfo.type()),i=O(s._coverageInfo.type());return o.localeCompare(i)||t(e,s)};case"size":return(e,s)=>e._coverageInfo.size()-s._coverageInfo.size()||t(e,s);case"bars":case"unusedSize":return(e,s)=>e._coverageInfo.unusedSize()-s._coverageInfo.unusedSize()||t(e,s);default:return console.assert(!1,"Unknown sort field: "+e),null}}}var D=Object.freeze({__proto__:null,coverageTypeToString:O,CoverageListView:V,GridNode:N});class J{constructor(e){this._coverageModel=e,this._textByProvider=new Map,this._uiSourceCodeByContentProvider=new Platform.Multimap;for(const e of b.WorkspaceImpl.instance().uiSourceCodes())e.addLineDecoration(0,"coverage",this);b.WorkspaceImpl.instance().addEventListener(b.Events.UISourceCodeAdded,this._onUISourceCodeAdded,this)}reset(){for(const e of b.WorkspaceImpl.instance().uiSourceCodes())e.removeDecorationsForType("coverage")}dispose(){this.reset(),b.WorkspaceImpl.instance().removeEventListener(b.Events.UISourceCodeAdded,this._onUISourceCodeAdded,this)}update(e){for(const t of e)for(const e of this._uiSourceCodeByContentProvider.get(t.contentProvider()))e.removeDecorationsForType("coverage"),e.addLineDecoration(0,"coverage",this)}async usageByLine(e){const t=[],{content:s}=await e.requestContent();if(!s)return[];const o=new l.Text(s);await this._updateTexts(e,o);const i=o.lineEndings();for(let s=0;s<o.lineCount();++s){const o=i[s]-(s?i[s-1]:0)-1;if(!o){t.push(void 0);continue}const n=this._rawLocationsForSourceLocation(e,s,0),r=this._rawLocationsForSourceLocation(e,s,o),[a,c]=await Promise.all([n,r]);let l=void 0;for(let e=0,t=0;e<a.length;++e){const s=a[e];for(;t<c.length&&J._compareLocations(s,c[t])>=0;)++t;if(t>=c.length||c[t].id!==s.id)continue;const o=c[t++],i=this._textByProvider.get(o.contentProvider);if(!i)continue;const n=i.value();let r=Math.min(i.offsetFromPosition(s.line,s.column),n.length-1),h=Math.min(i.offsetFromPosition(o.line,o.column),n.length-1);for(;r<=h&&/\s/.test(n[r]);)++r;for(;r<=h&&/\s/.test(n[h]);)--h;if(r<=h&&(l=this._coverageModel.usageForRange(o.contentProvider,r,h)),l)break}t.push(l)}return t}async _updateTexts(e,t){const s=[];for(let o=0;o<t.lineCount();++o)for(const t of await this._rawLocationsForSourceLocation(e,o,0))this._textByProvider.has(t.contentProvider)||(this._textByProvider.set(t.contentProvider,null),this._uiSourceCodeByContentProvider.set(t.contentProvider,e),s.push(this._updateTextForProvider(t.contentProvider)));return Promise.all(s)}async _updateTextForProvider(e){const{content:t}=await e.requestContent();this._textByProvider.set(e,new l.Text(t||""))}async _rawLocationsForSourceLocation(e,t,s){const o=[],i=e.contentType();if(i.hasScripts()){let n=await w.DebuggerWorkspaceBinding.instance().uiLocationToRawLocations(e,t,s);n=n.filter(e=>!!e.script());for(const e of n){const t=e.script();t.isInlineScript()&&i.isDocument()&&(e.lineNumber-=t.lineOffset,e.lineNumber||(e.columnNumber-=t.columnOffset)),o.push({id:"js:"+e.scriptId,contentProvider:e.script(),line:e.lineNumber,column:e.columnNumber})}}if(i.isStyleSheet()||i.isDocument()){const n=T.CSSWorkspaceBinding.instance().uiLocationToRawLocations(new B.UILocation(e,t,s));for(const e of n){const t=e.header();t&&(t.isInline&&i.isDocument()&&(e.lineNumber-=t.startLine,e.lineNumber||(e.columnNumber-=t.startColumn)),o.push({id:"css:"+e.styleSheetId,contentProvider:e.header(),line:e.lineNumber,column:e.columnNumber}))}}return o.sort(J._compareLocations)}static _compareLocations(e,t){return e.id.localeCompare(t.id)||e.line-t.line||e.column-t.column}_onUISourceCodeAdded(e){e.data.addLineDecoration(0,"coverage",this)}}var j=Object.freeze({__proto__:null,decoratorType:"coverage",CoverageDecorationManager:J,RawLocation:void 0});class G extends f.VBox{constructor(){super(!0),this._model=null,this._decorationManager=null,this._resourceTreeModel=null,this.registerRequiredCSS("coverage/coverageView.css");const e=this.contentElement.createChild("div","coverage-toolbar-container"),t=new S.Toolbar("coverage-toolbar",e);this._coverageTypeComboBox=new S.ToolbarComboBox(this._onCoverageTypeComboBoxSelectionChanged.bind(this),ls`Choose coverage granularity: Per function has low overhead, per block has significant overhead.`);const n=[{label:ls`Per function`,value:L.JavaScript|L.JavaScriptPerFunction},{label:ls`Per block`,value:L.JavaScript}];for(const e of n)this._coverageTypeComboBox.addOption(this._coverageTypeComboBox.createOption(e.label,e.value));this._coverageTypeComboBoxSetting=s.Settings.instance().createSetting("coverageViewCoverageType",0),this._coverageTypeComboBox.setSelectedIndex(this._coverageTypeComboBoxSetting.get()),this._coverageTypeComboBox.setEnabled(!0),t.appendToolbarItem(this._coverageTypeComboBox),this._toggleRecordAction=C.ActionRegistry.instance().action("coverage.toggle-recording"),this._toggleRecordButton=S.Toolbar.createActionButton(this._toggleRecordAction),t.appendToolbarItem(this._toggleRecordButton);const r=i.TargetManager.instance().mainTarget();if(r&&r.model(c.ResourceTreeModel)){this._inlineReloadButton=null;const e=C.ActionRegistry.instance().action("coverage.start-with-reload");this._startWithReloadButton=S.Toolbar.createActionButton(e),t.appendToolbarItem(this._startWithReloadButton),this._toggleRecordButton.setEnabled(!1),this._toggleRecordButton.setVisible(!1)}this._clearButton=new S.ToolbarButton(o.UIString("Clear all"),"largeicon-clear"),this._clearButton.addEventListener(S.ToolbarButton.Events.Click,this._clear.bind(this)),t.appendToolbarItem(this._clearButton),t.appendSeparator(),this._saveButton=new S.ToolbarButton(o.UIString("Export..."),"largeicon-download"),this._saveButton.addEventListener(S.ToolbarButton.Events.Click,e=>{this._exportReport()}),t.appendToolbarItem(this._saveButton),this._saveButton.setEnabled(!1),this._textFilterRegExp=null,t.appendSeparator(),this._filterInput=new S.ToolbarInput(o.UIString("URL filter"),"",.4,1),this._filterInput.setEnabled(!1),this._filterInput.addEventListener(S.ToolbarInput.Event.TextChanged,this._onFilterChanged,this),t.appendToolbarItem(this._filterInput),t.appendSeparator(),this._typeFilterValue=null,this._filterByTypeComboBox=new S.ToolbarComboBox(this._onFilterByTypeChanged.bind(this),ls`Filter coverage by type`);const a=[{label:ls`All`,value:""},{label:ls`CSS`,value:L.CSS},{label:ls`JavaScript`,value:L.JavaScript|L.JavaScriptPerFunction}];for(const e of a)this._filterByTypeComboBox.addOption(this._filterByTypeComboBox.createOption(e.label,e.value));this._filterByTypeComboBox.setSelectedIndex(0),this._filterByTypeComboBox.setEnabled(!1),t.appendToolbarItem(this._filterByTypeComboBox),t.appendSeparator(),this._showContentScriptsSetting=s.Settings.instance().createSetting("showContentScripts",!1),this._showContentScriptsSetting.addChangeListener(this._onFilterChanged,this),this._contentScriptsCheckbox=new S.ToolbarSettingCheckbox(this._showContentScriptsSetting,o.UIString("Include extension content scripts"),o.UIString("Content scripts")),this._contentScriptsCheckbox.setEnabled(!1),t.appendToolbarItem(this._contentScriptsCheckbox),this._coverageResultsElement=this.contentElement.createChild("div","coverage-results"),this._landingPage=this._buildLandingPage(),this._listView=new V(this._isVisible.bind(this,!1)),this._statusToolbarElement=this.contentElement.createChild("div","coverage-toolbar-summary"),this._statusMessageElement=this._statusToolbarElement.createChild("div","coverage-message"),this._landingPage.show(this._coverageResultsElement)}_buildLandingPage(){const e=new f.VBox;let t;if(this._startWithReloadButton)this._inlineReloadButton=m.createInlineButton(S.Toolbar.createActionButtonForId("coverage.start-with-reload")),t=m.formatLocalized("Click the reload button %s to reload and start capturing coverage.",[this._inlineReloadButton]);else{const e=m.createInlineButton(S.Toolbar.createActionButton(this._toggleRecordAction));t=m.formatLocalized("Click the record button %s to start capturing coverage.",[e])}return t.classList.add("message"),e.contentElement.appendChild(t),e.element.classList.add("landing-page"),e}_clear(){this._model&&this._model.reset(),this._reset()}_reset(){this._decorationManager&&(this._decorationManager.dispose(),this._decorationManager=null),this._listView.reset(),this._listView.detach(),this._landingPage.show(this._coverageResultsElement),this._statusMessageElement.textContent="",this._filterInput.setEnabled(!1),this._filterByTypeComboBox.setEnabled(!1),this._contentScriptsCheckbox.setEnabled(!1),this._saveButton.setEnabled(!1)}_toggleRecording(){!this._toggleRecordAction.toggled()?this._startRecording({reload:!1,jsCoveragePerBlock:this.isBlockCoverageSelected()}):this.stopRecording()}isBlockCoverageSelected(){return Number(this._coverageTypeComboBox.selectedOption().value)===L.JavaScript}_selectCoverageType(e){const t=e?1:0;this._coverageTypeComboBox.setSelectedIndex(t)}_onCoverageTypeComboBoxSelectionChanged(){this._coverageTypeComboBoxSetting.set(this._coverageTypeComboBox.selectedIndex())}async ensureRecordingStarted(){this._toggleRecordAction.toggled()&&await this.stopRecording(),await this._startRecording({reload:!1,jsCoveragePerBlock:!1})}async _startRecording(e){let t,s;this._startWithReloadButton&&this._startWithReloadButton.element.hasFocus()||this._inlineReloadButton&&this._inlineReloadButton.hasFocus()?s=!0:this.hasFocus()&&(t=!0),this._reset();const o=i.TargetManager.instance().mainTarget();if(!o)return;const{reload:n,jsCoveragePerBlock:r}={reload:!1,jsCoveragePerBlock:!1,...e};this._model&&!n||(this._model=o.model(E)),R.actionTaken(P.Action.CoverageStarted),r&&R.actionTaken(P.Action.CoverageStartedPerBlock);await this._model.start(r)&&(this._selectCoverageType(r),this._model.addEventListener(M.CoverageUpdated,this._onCoverageDataReceived,this),this._resourceTreeModel=o.model(c.ResourceTreeModel),this._resourceTreeModel&&this._resourceTreeModel.addEventListener(c.Events.MainFrameNavigated,this._onMainFrameNavigated,this),this._decorationManager=new J(this._model),this._toggleRecordAction.setToggled(!0),this._clearButton.setEnabled(!1),this._startWithReloadButton&&(this._startWithReloadButton.setEnabled(!1),this._startWithReloadButton.setVisible(!1),this._toggleRecordButton.setEnabled(!0),this._toggleRecordButton.setVisible(!0),s&&this._toggleRecordButton.element.focus()),this._coverageTypeComboBox.setEnabled(!1),this._filterInput.setEnabled(!0),this._filterByTypeComboBox.setEnabled(!0),this._contentScriptsCheckbox.setEnabled(!0),this._landingPage.isShowing()&&this._landingPage.detach(),this._listView.show(this._coverageResultsElement),t&&!s&&this._listView.focus(),n&&this._resourceTreeModel?this._resourceTreeModel.reloadPage():this._model.startPolling())}_onCoverageDataReceived(e){const t=e.data;this._updateViews(t)}async stopRecording(){this._resourceTreeModel&&(this._resourceTreeModel.removeEventListener(c.Events.MainFrameNavigated,this._onMainFrameNavigated,this),this._resourceTreeModel=null),this.hasFocus()&&this._listView.focus(),await this._model.stop(),this._model.removeEventListener(M.CoverageUpdated,this._onCoverageDataReceived,this),this._toggleRecordAction.setToggled(!1),this._coverageTypeComboBox.setEnabled(!0),this._startWithReloadButton&&(this._startWithReloadButton.setEnabled(!0),this._startWithReloadButton.setVisible(!0),this._toggleRecordButton.setEnabled(!1),this._toggleRecordButton.setVisible(!1)),this._clearButton.setEnabled(!0)}processBacklog(){this._model.processJSBacklog()}_onMainFrameNavigated(){this._model.reset(),this._decorationManager.reset(),this._listView.reset(),this._model.startPolling()}_updateViews(e){this._updateStats(),this._listView.update(this._model.entries()),this._saveButton.setEnabled(this._model.entries().length>0),this._decorationManager.update(e)}_updateStats(){const e={total:0,unused:0},t={total:0,unused:0};let s=!1;if(this._model)for(const o of this._model.entries())e.total+=o.size(),e.unused+=o.unusedSize(),this._isVisible(!1,o)?(t.total+=o.size(),t.unused+=o.unusedSize()):s=!0;function o({total:e,unused:t}){const s=e-t,o=e?Math.round(100*s/e):0;return ls`${p.bytesToString(s)} of ${p.bytesToString(e)} (${o}%) used so far,
        ${p.bytesToString(t)} unused.`}this._statusMessageElement.textContent=s?ls`Filtered: ${o(t)}  Total: ${o(e)}`:o(e)}_onFilterChanged(){if(!this._listView)return;const e=this._filterInput.value();this._textFilterRegExp=e?createPlainTextSearchRegex(e,"i"):null,this._listView.updateFilterAndHighlight(this._textFilterRegExp),this._updateStats()}_onFilterByTypeChanged(){if(!this._listView)return;R.actionTaken(P.Action.CoverageReportFiltered);const e=this._filterByTypeComboBox.selectedOption().value;this._typeFilterValue=parseInt(e,10)||null,this._listView.updateFilterAndHighlight(this._textFilterRegExp),this._updateStats()}_isVisible(e,t){const s=t.url();return!s.startsWith(G._extensionBindingsURLPrefix)&&(!(t.isContentScript()&&!this._showContentScriptsSetting.get())&&(!(this._typeFilterValue&&!(t.type()&this._typeFilterValue))&&(e||!this._textFilterRegExp||this._textFilterRegExp.test(s))))}async _exportReport(){const e=new x.FileOutputStream,t=`Coverage-${v.toISO8601Compact(new Date)}.json`;await e.open(t)&&this._model.exportReport(e)}selectCoverageItemByUrl(e){this._listView.selectByUrl(e)}}G._extensionBindingsURLPrefix="extensions::";class W{constructor(){this._listeners=new WeakMap}decorate(e,t){const s=e.decorationsForType("coverage");if(!s||!s.size)return void this._uninstallGutter(t);s.values().next().value.data().usageByLine(e).then(s=>{t.operation(()=>this._innerDecorate(e,t,s))})}_innerDecorate(e,t,s){const o=W._gutterType;this._uninstallGutter(t),s.length&&this._installGutter(t,e.url());for(let e=0;e<s.length;++e){if("boolean"!=typeof s[e])continue;const i=s[e]?"text-editor-coverage-used-marker":"text-editor-coverage-unused-marker",n=document.createElement("div");n.classList.add(i),t.setGutterDecoration(e,o,n)}}makeGutterClickHandler(e){return function(t){if(t.data.gutterType!==W._gutterType)return;y.ViewManager.instance().showView("coverage").then(()=>y.ViewManager.instance().view("coverage").widget()).then(t=>{const s=e.match(/(.*):formatted$/),o=s&&s[1]||e;t.selectCoverageItemByUrl(o)})}}_installGutter(e,t){let s=this._listeners.get(e);s||(s=this.makeGutterClickHandler(t),this._listeners.set(e,s)),e.installGutter(W._gutterType,!1),e.addEventListener(I.Events.GutterClick,s,this)}_uninstallGutter(e){e.uninstallGutter(W._gutterType);const t=this._listeners.get(e);t&&(e.removeEventListener(I.Events.GutterClick,t,this),this._listeners.delete(e))}}W._gutterType="CodeMirror-gutter-coverage";var $=Object.freeze({__proto__:null,CoverageView:G,ActionDelegate:class{handleAction(e,t){return y.ViewManager.instance().showView("coverage",!1,!0).then(()=>y.ViewManager.instance().view("coverage").widget()).then(e=>this._innerHandleAction(e,t)),!0}_innerHandleAction(e,t){switch(t){case"coverage.toggle-recording":e._toggleRecording();break;case"coverage.start-with-reload":e._startRecording({reload:!0,jsCoveragePerBlock:e.isBlockCoverageSelected()});break;default:console.assert(!1,"Unknown action: "+t)}}},LineDecorator:W});export{j as CoverageDecorationManager,D as CoverageListView,U as CoverageModel,$ as CoverageView};
